#!/usr/bin/env python

# Mimic a binary that generates an object file (e.g. windres).

import sys, shutil, subprocess

if __name__ == '__main__':
    if len(sys.argv) != 4:
        print(sys.argv[0], 'compiler input_file output_file')
        sys.exit(1)
    compiler = sys.argv[1]
    ifile = sys.argv[2]
    ofile = sys.argv[3]
    if compiler.endswith('cl'):
        cmd = [compiler, '/nologo', '/MDd', '/Fo'+ofile, '/c', ifile]
    else:
        cmd = [compiler, '-c', ifile, '-o', ofile]
    sys.exit(subprocess.call(cmd))
